/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.configuration;

import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.configuration.Property;
import org.sonar.jpa.session.DatabaseSessionFactory;

public class DatabaseConfiguration
extends BaseConfiguration {
    private DatabaseSessionFactory sessionFactory;
    private DatabaseSession session;

    public DatabaseConfiguration(DatabaseSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.load();
    }

    public DatabaseConfiguration(DatabaseSession session) {
        this.session = session;
        this.load();
    }

    public void load() {
        this.clear();
        List properties = this.getSession().createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId is null and p.userId is null").getResultList();
        if (properties != null) {
            for (Property property : properties) {
                this.setProperty(property.getKey(), property.getValue());
            }
        }
    }

    private DatabaseSession getSession() {
        if (this.session != null) {
            return this.session;
        }
        return this.sessionFactory.getSession();
    }
}

