/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.page.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import java.util.List;
import org.sonar.gwt.Links;
import org.sonar.gwt.ui.Icons;
import org.sonar.plugins.design.ui.page.client.DependencyInfo;
import org.sonar.plugins.design.ui.page.client.DsmData;
import org.sonar.plugins.design.ui.page.client.I18nConstants;

public class Dsm
extends Composite {
    public static final String DSM = "dsm";
    public static final String HEADER = "htable";
    public static final String HEADER_TITLE = "ht";
    public static final String HEADER_SELECTED_SUFFIX = "s";
    public static final String HEADER_INDICATOR = "hi";
    public static final String HEADER_HIGHER_INDICATOR_SUFFIX = "h";
    public static final String HEADER_LOWER_INDICATOR_SUFFIX = "l";
    public static final String GRID = "gtable";
    public static final String GRID_CELL_BOTTOM_LEFT = "cbl";
    public static final String GRID_CELL_TOP_RIGHT = "ctr";
    public static final String GRID_CELL_DIAGONAL = "cd";
    public static final String GRID_CELL_SELECTION1_SUFFIX = "s1";
    public static final String GRID_CELL_SELECTION2_SUFFIX = "s2";
    public static final String GRID_CELL_COMB1_SUFFIX = "c1";
    public static final String GRID_CELL_COMB2_SUFFIX = "c2";
    public static final String[] GRID_SUFFIXES = new String[]{"s1", "s2", "c1", "c2"};
    private VerticalPanel dsm = new VerticalPanel();
    private DsmData.Rows data;
    private Label[][] cells;
    private Label[] titles;
    private Label[] indicators;
    private List<Label> highlightedCells = new LinkedList<Label>();

    public Dsm() {
        this.dsm.setStylePrimaryName(DSM);
        this.initWidget((Widget)this.dsm);
    }

    private Widget createLegend() {
        HorizontalPanel legend = new HorizontalPanel();
        legend.getElement().setId("dsmlegend");
        legend.add((Widget)new HTML("<div class='square gray'> </div>"));
        legend.add((Widget)new Label(I18nConstants.INSTANCE.legendDependencies()));
        legend.add((Widget)new HTML("<div class='space'></div>"));
        legend.add((Widget)new HTML("<div class='square red'> </div> "));
        legend.add((Widget)new Label(I18nConstants.INSTANCE.legendCycles()));
        legend.add((Widget)new HTML(" <div class='space'></div> "));
        legend.add((Widget)new HTML("<div class='square green'></div> "));
        legend.add((Widget)new Label(I18nConstants.INSTANCE.legendUses()));
        legend.add((Widget)new HTML("<div class='square blue'></div> "));
        legend.add((Widget)new Label(I18nConstants.INSTANCE.legendUses()));
        legend.add((Widget)new HTML(" <div class='square yellow'></div>"));
        return legend;
    }

    public void displayNoData() {
        this.dsm.clear();
        this.dsm.add((Widget)new Label(I18nConstants.INSTANCE.noData()));
    }

    public void display(DsmData.Rows data) {
        if (data == null) {
            this.displayNoData();
        } else {
            this.data = data;
            this.dsm.clear();
            this.dsm.add(this.createHelp());
            this.dsm.add(this.createLegend());
            HorizontalPanel matrix = new HorizontalPanel();
            matrix.add((Widget)this.createRowHeader());
            matrix.add((Widget)this.createGrid());
            this.dsm.add((Widget)matrix);
        }
    }

    private Widget createHelp() {
        HorizontalPanel help = new HorizontalPanel();
        help.getElement().setId("dsmhelp");
        Anchor link = new Anchor(I18nConstants.INSTANCE.linkToHelp(), "http://docs.codehaus.org/x/QQFhC", "docsonar");
        help.add((Widget)Icons.get().help().createImage());
        help.add((Widget)link);
        return help;
    }

    private Grid createRowHeader() {
        Grid header = new Grid(this.data.size(), 2);
        header.setCellPadding(0);
        header.setCellSpacing(0);
        header.setStylePrimaryName(HEADER);
        this.titles = new Label[this.data.size()];
        this.indicators = new Label[this.data.size()];
        for (int indexRow = 0; indexRow < this.data.size(); ++indexRow) {
            DsmData.Row row = this.data.get(indexRow);
            HTML title = this.buildRowTitle(indexRow, row);
            this.titles[indexRow] = title;
            header.setWidget(indexRow, 0, (Widget)title);
            Label indicator = Dsm.buildLabel("", HEADER_INDICATOR);
            header.setWidget(indexRow, 1, (Widget)indicator);
            this.indicators[indexRow] = indicator;
        }
        return header;
    }

    private Grid createGrid() {
        int rowsCount = this.data.size();
        Grid grid = new Grid(rowsCount, rowsCount);
        grid.setCellPadding(0);
        grid.setCellSpacing(0);
        grid.setStylePrimaryName(GRID);
        return this.loadGridCells(grid, this.data);
    }

    private Grid loadGridCells(Grid grid, DsmData.Rows data) {
        int size = data.size();
        this.cells = new Label[size][size];
        for (int row = 0; row < size; ++row) {
            DsmData.Row resource = data.get(row);
            for (int col = 0; col < resource.size(); ++col) {
                Label cell = this.createGridCell(row, col, resource.getWeight(col));
                grid.setWidget(row, col, (Widget)cell);
                this.cells[row][col] = cell;
            }
        }
        return grid;
    }

    public void onCellClicked(int row, int col) {
        this.cancelHighlighting();
        this.highlightTitle(row);
        this.highlightTitle(col);
        this.highlightIndicator(row);
        this.highlightIndicator(col);
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells.length; ++j) {
                Label cell = this.cells[i][j];
                if (i == row && j == col) {
                    this.highlightCell(cell, GRID_CELL_SELECTION1_SUFFIX);
                    continue;
                }
                if (j == row && i == col) {
                    this.highlightCell(cell, GRID_CELL_SELECTION1_SUFFIX);
                    continue;
                }
                if (j == col || i == col) {
                    this.highlightCell(cell, GRID_CELL_COMB1_SUFFIX);
                    continue;
                }
                if (i != row && j != row) continue;
                this.highlightCell(cell, GRID_CELL_COMB2_SUFFIX);
            }
        }
    }

    private void displayDependencyInfo(int row, int col) {
        DsmData.Cell cell = this.data.get(row).getCell(col);
        DependencyInfo.getInstance().showOrPopup(cell.getDependencyId());
    }

    public void onTitleClicked(int row) {
        this.cancelHighlighting();
        this.highlightTitle(row);
        this.highlightIndicator(row);
        for (int col = 0; col < this.cells[row].length; ++col) {
            this.highlightCell(this.cells[row][col], GRID_CELL_SELECTION2_SUFFIX);
            if (col >= row || !this.hasWeight(this.cells[row][col])) continue;
            this.highlightIndicator(col, true);
        }
        for (int i = 0; i < this.cells.length; ++i) {
            if (i == row) continue;
            this.highlightCell(this.cells[i][row], GRID_CELL_SELECTION2_SUFFIX);
            if (i <= row || !this.hasWeight(this.cells[i][row])) continue;
            this.highlightIndicator(i, false);
        }
    }

    private boolean hasWeight(Label label) {
        return label.getText().length() > 0;
    }

    private void cancelHighlighting() {
        this.cancelGridHighlighting();
        this.cancelIndicatorsHighlighting();
        this.cancelTitlesHighlighting();
    }

    private void cancelGridHighlighting() {
        for (Label cell : this.highlightedCells) {
            for (String suffix : GRID_SUFFIXES) {
                cell.removeStyleDependentName(suffix);
            }
        }
        this.highlightedCells.clear();
    }

    private void highlightCell(Label cell, String style) {
        cell.addStyleDependentName(style);
        this.highlightedCells.add(cell);
    }

    private void highlightTitle(int row) {
        this.titles[row].addStyleDependentName(HEADER_SELECTED_SUFFIX);
    }

    private void cancelTitlesHighlighting() {
        for (Label title : this.titles) {
            title.removeStyleDependentName(HEADER_SELECTED_SUFFIX);
        }
    }

    private void cancelIndicatorsHighlighting() {
        for (Label indicator : this.indicators) {
            indicator.removeStyleDependentName(HEADER_HIGHER_INDICATOR_SUFFIX);
            indicator.removeStyleDependentName(HEADER_LOWER_INDICATOR_SUFFIX);
            indicator.removeStyleDependentName(HEADER_SELECTED_SUFFIX);
        }
    }

    private void highlightIndicator(int row) {
        this.indicators[row].addStyleDependentName(HEADER_SELECTED_SUFFIX);
    }

    private void highlightIndicator(int row, boolean higher) {
        this.indicators[row].addStyleDependentName(higher ? HEADER_HIGHER_INDICATOR_SUFFIX : HEADER_LOWER_INDICATOR_SUFFIX);
    }

    private Label createGridCell(int row, int col, int weight) {
        Label cell = row == col ? this.createDiagonalCell(row) : this.createNonDiagonalCell(row, col, weight);
        return cell;
    }

    private Label createNonDiagonalCell(int row, int col, int weight) {
        Label cell = this.buildCell(row, col, weight, col > row ? GRID_CELL_TOP_RIGHT : GRID_CELL_BOTTOM_LEFT);
        if (weight > 0) {
            String tooltip = this.data.get(col).getName() + " -> " + this.data.get(row).getName() + " (" + weight + "). " + I18nConstants.INSTANCE.cellTooltip();
            cell.setTitle(tooltip);
        }
        return cell;
    }

    private Label createDiagonalCell(final int row) {
        Label cell = Dsm.buildLabel("-", GRID_CELL_DIAGONAL);
        cell.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Dsm.this.onTitleClicked(row);
            }
        });
        return cell;
    }

    private HTML buildRowTitle(int indexRow, final DsmData.Row row) {
        HTML title = new HTML(Icons.forQualifier((String)row.getQualifier()).getHTML() + " " + row.getName()){
            {
                super(x0);
                this.addDomHandler((EventHandler)new DoubleClickHandler(){

                    public void onDoubleClick(DoubleClickEvent pEvent) {
                        if (row.getId() != null) {
                            if (!"FIL".equals(row.getQualifier()) && !"CLA".equals(row.getQualifier())) {
                                Window.Location.assign((String)Links.urlForResourcePage((String)row.getId(), (String)"org.sonar.plugins.design.ui.page.DesignPage", null));
                            } else {
                                Links.openMeasurePopup((String)row.getId(), null);
                            }
                        }
                    }
                }, DoubleClickEvent.getType());
            }
        };
        title.setStylePrimaryName(HEADER_TITLE);
        title.setTitle(I18nConstants.INSTANCE.rowTooltip());
        final int finalIndexRow = indexRow;
        title.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Dsm.this.onTitleClicked(finalIndexRow);
            }
        });
        return title;
    }

    private static Label buildLabel(String text, String primaryStyle) {
        Label label = new Label(text);
        label.setStylePrimaryName(primaryStyle);
        return label;
    }

    private Label buildCell(final int row, final int col, int weight, String primaryStyle) {
        String text = "";
        if (weight > 0) {
            text = "<span>" + Integer.toString(weight) + "</span>";
        }
        HTML cell = new HTML(text){
            {
                super(x0);
                this.addDomHandler((EventHandler)new DoubleClickHandler(){

                    public void onDoubleClick(DoubleClickEvent pEvent) {
                        Dsm.this.displayDependencyInfo(row, col);
                    }
                }, DoubleClickEvent.getType());
            }
        };
        cell.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Dsm.this.onCellClicked(row, col);
            }
        });
        cell.setStylePrimaryName(primaryStyle);
        return cell;
    }
}

