/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.page.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.sonar.gwt.Configuration;
import org.sonar.gwt.Links;
import org.sonar.gwt.ui.Icons;
import org.sonar.gwt.ui.Loading;
import org.sonar.plugins.design.ui.page.client.I18nConstants;
import org.sonar.wsclient.gwt.AbstractCallback;
import org.sonar.wsclient.gwt.AbstractListCallback;
import org.sonar.wsclient.gwt.Callback;
import org.sonar.wsclient.gwt.ListCallback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Dependency;
import org.sonar.wsclient.services.DependencyQuery;
import org.sonar.wsclient.services.Query;

public class DependencyInfo
extends Composite {
    private static DependencyInfo INSTANCE = new DependencyInfo();
    private VerticalPanel panel;
    private Loading loading = new Loading();
    private String currentDependencyId = null;
    private boolean popupMode = false;

    private DependencyInfo() {
        this.panel = new VerticalPanel();
        this.initWidget((Widget)this.panel);
    }

    public static DependencyInfo getInstance() {
        return INSTANCE;
    }

    public void showOrPopup(String dependencyId) {
        if (this.popupMode) {
            Window.open((String)Links.urlForResourcePage((String)Configuration.getResourceId(), (String)"org.sonar.plugins.design.ui.page.DesignPage", (String)("layout=false&depId=" + dependencyId)), (String)"dependency", (String)"height=800,width=900,scrollbars=1,resizable=1");
        } else {
            INSTANCE.show(dependencyId);
        }
    }

    public void show(String dependencyId) {
        this.panel.clear();
        this.currentDependencyId = dependencyId;
        if (dependencyId != null) {
            this.panel.add((Widget)this.loading);
            this.loadDependency(dependencyId);
        }
    }

    public DependencyInfo setPopupMode(boolean b) {
        this.popupMode = b;
        return this;
    }

    public void popup() {
        this.popupMode = true;
        this.panel.clear();
        this.showOrPopup(this.currentDependencyId);
    }

    private void setLoaded() {
        this.loading.removeFromParent();
    }

    private void loadDependency(String dependencyId) {
        DependencyQuery query = DependencyQuery.createForId((String)dependencyId);
        Sonar.getInstance().find((Query)query, (Callback)new AbstractCallback<Dependency>(){

            protected void doOnResponse(Dependency dependency) {
                if (dependency == null) {
                    DependencyInfo.this.setLoaded();
                    DependencyInfo.this.panel.add((Widget)new Label(I18nConstants.INSTANCE.noData()));
                } else {
                    DependencyInfo.this.loadSubDependencies(dependency);
                }
            }

            protected void doOnError(int errorCode, String errorMessage) {
                super.doOnError(errorCode, errorMessage);
            }
        });
    }

    private void loadSubDependencies(final Dependency dependency) {
        DependencyQuery query = DependencyQuery.createForSubDependencies((String)dependency.getId());
        Sonar.getInstance().findAll((Query)query, (ListCallback)new AbstractListCallback<Dependency>(){

            protected void doOnResponse(List<Dependency> subDependencies) {
                Grid table = new Grid(subDependencies.size() + 1, 5);
                table.setStyleName("depInfo");
                DependencyInfo.this.createHeader(dependency, table);
                for (int row = 0; row < subDependencies.size(); ++row) {
                    Dependency dep = subDependencies.get(row);
                    table.setWidget(row + 1, 0, (Widget)new HTML(Icons.forQualifier((String)dep.getFromQualifier()).getHTML()));
                    if ("FIL".equals(dep.getFromQualifier()) || "CLA".equals(dep.getFromQualifier())) {
                        table.setWidget(row + 1, 1, (Widget)DependencyInfo.this.createLink(dep.getFromId(), dep.getFromName()));
                    } else {
                        table.setText(row + 1, 1, dep.getFromName());
                    }
                    table.setText(row + 1, 2, "  " + dep.getUsage() + "  ");
                    table.setWidget(row + 1, 3, (Widget)new HTML(Icons.forQualifier((String)dep.getToQualifier()).getHTML()));
                    if ("FIL".equals(dep.getToQualifier()) || "CLA".equals(dep.getToQualifier())) {
                        table.setWidget(row + 1, 4, (Widget)DependencyInfo.this.createLink(dep.getToId(), dep.getToName()));
                        continue;
                    }
                    table.setText(row + 1, 4, dep.getToName());
                }
                DependencyInfo.this.panel.clear();
                if (!DependencyInfo.this.popupMode) {
                    DependencyInfo.this.panel.add(DependencyInfo.this.createNewWindowLink());
                }
                DependencyInfo.this.panel.add((Widget)table);
            }
        });
    }

    private Label createLink(final long resourceId, String resourceName) {
        Label link = new Label(resourceName);
        link.setStyleName("link");
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Links.openResourcePopup((String)String.valueOf(resourceId));
            }
        });
        return link;
    }

    private void createHeader(Dependency dependency, Grid grid) {
        grid.getRowFormatter().setStyleName(0, "depInfoHeader");
        grid.setWidget(0, 0, (Widget)Icons.forQualifier((String)dependency.getFromQualifier()).createImage());
        grid.setText(0, 1, dependency.getFromName());
        grid.setWidget(0, 3, (Widget)Icons.forQualifier((String)dependency.getToQualifier()).createImage());
        grid.setText(0, 4, dependency.getToName());
    }

    private Widget createNewWindowLink() {
        Label popup = new Label(I18nConstants.INSTANCE.newWindow());
        popup.setStyleName("newwindow");
        popup.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DependencyInfo.this.popup();
            }
        });
        return popup;
    }
}

