/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.libraries.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.sonar.gwt.ui.Icons;
import org.sonar.gwt.ui.Loading;
import org.sonar.plugins.design.ui.libraries.client.Filters;
import org.sonar.plugins.design.ui.libraries.client.I18nConstants;
import org.sonar.plugins.design.ui.libraries.client.Library;
import org.sonar.wsclient.gwt.AbstractListCallback;
import org.sonar.wsclient.gwt.ListCallback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.DependencyTree;
import org.sonar.wsclient.services.DependencyTreeQuery;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;

public class ProjectPanel
extends FlowPanel {
    private Label title;
    private Tree tree;
    private Filters filters;

    public ProjectPanel(Resource project, Filters filters) {
        this.filters = filters;
        this.setStyleName("libs");
        this.getElement().setId("libs-" + project.getKey());
        this.add((Widget)new Loading(project.getName()));
        this.loadLibraries(project);
    }

    private void loadLibraries(final Resource project) {
        Sonar.getInstance().findAll((Query)DependencyTreeQuery.createForProject((String)project.getId().toString()), (ListCallback)new AbstractListCallback<DependencyTree>(){

            protected void doOnResponse(List<DependencyTree> dependencyTrees) {
                this.createTitle(project);
                this.createTree();
                if (dependencyTrees == null || dependencyTrees.isEmpty()) {
                    ProjectPanel.this.clear();
                    ProjectPanel.this.add((Widget)ProjectPanel.this.title);
                    ProjectPanel.this.add((Widget)ProjectPanel.this.createNoLibsMessage());
                } else {
                    this.display(dependencyTrees, null);
                    ProjectPanel.this.filter();
                    ProjectPanel.this.clear();
                    ProjectPanel.this.add((Widget)ProjectPanel.this.title);
                    ProjectPanel.this.add((Widget)ProjectPanel.this.tree);
                }
            }

            private void createTitle(Resource project2) {
                String html = Icons.forQualifier((String)project2.getQualifier()).getHTML();
                html = html + " <span class=''> " + project2.getName() + "</span> ";
                if (project2.getVersion() != null) {
                    html = html + project2.getVersion() + " ";
                }
                ProjectPanel.this.title = (Label)new HTML(html);
            }

            private void display(List<DependencyTree> depTrees, TreeItem parentLibrary) {
                if (depTrees != null) {
                    for (DependencyTree depTree : depTrees) {
                        Library library = new Library(depTree);
                        if (parentLibrary == null) {
                            ProjectPanel.this.tree.addItem((TreeItem)library);
                            library.setState(true);
                        } else {
                            parentLibrary.addItem((TreeItem)library);
                        }
                        this.display(depTree.getTo(), library);
                        library.setState(true);
                    }
                }
            }

            private void createTree() {
                ProjectPanel.this.tree = new Tree();
                ProjectPanel.this.tree.setAnimationEnabled(false);
            }
        });
    }

    private Label createNoLibsMessage() {
        Label msg = new Label(I18nConstants.INSTANCE.noLibraries());
        msg.setStyleName("nolibs");
        return msg;
    }

    public void filter() {
        boolean visible = this.tree.getItemCount() == 0 && !this.filters.hasKeyword();
        for (int index = 0; index < this.tree.getItemCount(); ++index) {
            Library lib = (Library)this.tree.getItem(index);
            visible |= !lib.filter(this.filters.getKeywordFilter().getKeyword(), this.filters.isTestFiltered());
        }
        this.setVisible(visible);
    }

    public void expandCollapse(boolean expand) {
        for (int index = 0; index < this.tree.getItemCount(); ++index) {
            this.openItem(this.tree.getItem(index), expand);
        }
    }

    private void openItem(TreeItem item, boolean open) {
        item.setState(open);
        for (int i = 0; i < item.getChildCount(); ++i) {
            this.openItem(item.getChild(i), open);
        }
    }
}

