/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.libraries.client;

import com.google.gwt.user.client.ui.TreeItem;
import org.sonar.gwt.ui.Icons;
import org.sonar.wsclient.services.DependencyTree;

public class Library
extends TreeItem {
    private String keywords;
    private String usage;

    public Library(DependencyTree dep) {
        this.setHTML(Library.toHTML(dep));
        this.keywords = Library.toKeywords(dep);
        this.usage = dep.getUsage();
    }

    private static String toKeywords(DependencyTree dep) {
        String text = dep.getResourceName() + " ";
        if (dep.getResourceKey() != null) {
            text = text + dep.getResourceKey() + " ";
        }
        if (dep.getResourceVersion() != null) {
            text = text + dep.getResourceVersion() + " ";
        }
        text = text + dep.getUsage();
        return text.toUpperCase();
    }

    public boolean containsKeyword(String keyword) {
        if (this.keywords.indexOf(keyword) >= 0) {
            return true;
        }
        for (int index = 0; index < this.getChildCount(); ++index) {
            if (!((Library)this.getChild(index)).containsKeyword(keyword)) continue;
            return true;
        }
        return false;
    }

    private static String toHTML(DependencyTree tree) {
        String html = Icons.forQualifier((String)tree.getResourceQualifier()).getHTML();
        html = html + " <span> " + tree.getResourceName() + "</span> ";
        if (tree.getResourceVersion() != null) {
            html = html + tree.getResourceVersion() + " ";
        }
        html = html + "(" + tree.getUsage() + ")";
        return html;
    }

    public boolean filter(String keyword, boolean testFiltered) {
        if (testFiltered && "test".equals(this.usage)) {
            this.setVisible(false);
            return true;
        }
        boolean filtered = false;
        if (!"".equals(keyword) && !this.containsKeyword(keyword)) {
            filtered = true;
        }
        boolean hasVisibleChild = false;
        for (int index = 0; index < this.getChildCount(); ++index) {
            hasVisibleChild |= !((Library)this.getChild(index)).filter(keyword, testFiltered);
        }
        boolean visible = !filtered || hasVisibleChild;
        this.setVisible(visible);
        return !visible;
    }
}

