/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.libraries.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.sonar.gwt.ui.Page;
import org.sonar.plugins.design.ui.libraries.client.Filters;
import org.sonar.plugins.design.ui.libraries.client.ProjectPanel;
import org.sonar.wsclient.gwt.AbstractListCallback;
import org.sonar.wsclient.gwt.ListCallback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class LibrariesPage
extends Page
implements KeyUpHandler,
ClickHandler {
    public static final String GWT_ID = "org.sonar.plugins.design.ui.libraries.LibrariesPage";
    private Filters filters;
    private List<ProjectPanel> projectPanels = new ArrayList<ProjectPanel>();
    private Panel container;

    protected Widget doOnResourceLoad(Resource resource) {
        this.container = new VerticalPanel();
        this.container.setWidth("100%");
        this.filters = new Filters(resource);
        this.filters.getKeywordFilter().addKeyUpHandler(this);
        this.filters.getTestCheckbox().addClickHandler((ClickHandler)this);
        this.filters.getExpandCollapseLink().addClickHandler((ClickHandler)this);
        this.container.add((Widget)this.filters);
        this.load(resource);
        return this.container;
    }

    private void load(Resource resource) {
        ResourceQuery resourceQuery = new ResourceQuery(resource.getId().toString());
        resourceQuery.setDepth(Integer.valueOf(-1)).setScopes(new String[]{"PRJ"});
        Sonar.getInstance().findAll((Query)resourceQuery, (ListCallback)new AbstractListCallback<Resource>(){

            protected void doOnResponse(List<Resource> subProjects) {
                for (Resource subProject : subProjects) {
                    ProjectPanel projectPanel = new ProjectPanel(subProject, LibrariesPage.this.filters);
                    LibrariesPage.this.projectPanels.add(projectPanel);
                    LibrariesPage.this.container.add((Widget)projectPanel);
                }
            }
        });
    }

    public void onKeyUp(KeyUpEvent event) {
        for (ProjectPanel projectPanel : this.projectPanels) {
            projectPanel.filter();
        }
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.filters.getTestCheckbox()) {
            for (ProjectPanel projectPanel : this.projectPanels) {
                projectPanel.filter();
            }
        } else if (event.getSource() == this.filters.getExpandCollapseLink()) {
            if (this.filters.isExpanded()) {
                this.filters.collapse();
                this.expandCollapseLibs(false);
            } else {
                this.filters.expand();
                this.expandCollapseLibs(true);
            }
        }
    }

    private void expandCollapseLibs(boolean expand) {
        for (ProjectPanel projectPanel : this.projectPanels) {
            projectPanel.expandCollapse(expand);
        }
    }
}

