/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.libraries.client;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.gwt.Configuration;
import org.sonar.gwt.Links;
import org.sonar.plugins.design.ui.libraries.client.I18nConstants;
import org.sonar.plugins.design.ui.libraries.client.KeywordFilter;
import org.sonar.wsclient.services.Resource;

public class Filters
extends Grid {
    private static final String PARAM_TEST = "test";
    private KeywordFilter keywordFilter;
    private CheckBox testCheckbox;
    private Anchor expandCollapse;
    private boolean isExpanded;
    private Anchor usageLink;

    public Filters(Resource resource) {
        super(1, 5);
        this.setStyleName("libFilter");
        this.keywordFilter = new KeywordFilter();
        this.setWidget(0, 0, (Widget)new Label(I18nConstants.INSTANCE.filter()));
        this.setWidget(0, 1, (Widget)this.keywordFilter);
        this.testCheckbox = new CheckBox(I18nConstants.INSTANCE.displayTests());
        this.testCheckbox.getElement().setId("testCb");
        this.testCheckbox.setValue(Boolean.valueOf(Configuration.getRequestParameter((String)PARAM_TEST, (String)"false")));
        this.setWidget(0, 2, (Widget)this.testCheckbox);
        this.expandCollapse = new Anchor(I18nConstants.INSTANCE.collapse());
        this.isExpanded = true;
        this.setWidget(0, 3, (Widget)this.expandCollapse);
        this.usageLink = new Anchor(I18nConstants.INSTANCE.usageLink(), Links.baseUrl() + "/dependencies/index?search=" + resource.getKey());
        this.setWidget(0, 4, (Widget)this.usageLink);
    }

    public KeywordFilter getKeywordFilter() {
        return this.keywordFilter;
    }

    public CheckBox getTestCheckbox() {
        return this.testCheckbox;
    }

    public boolean isTestDisplayed() {
        return this.testCheckbox.getValue();
    }

    public boolean isTestFiltered() {
        return !this.isTestDisplayed();
    }

    public boolean hasKeyword() {
        return this.getKeywordFilter().hasKeyword();
    }

    public Anchor getExpandCollapseLink() {
        return this.expandCollapse;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isCollapsed() {
        return !this.isExpanded;
    }

    public Anchor getUsageLink() {
        return this.usageLink;
    }

    public void expand() {
        if (!this.isExpanded) {
            this.expandCollapse.setText(I18nConstants.INSTANCE.collapse());
            this.isExpanded = true;
        }
    }

    public void collapse() {
        if (this.isExpanded) {
            this.expandCollapse.setText(I18nConstants.INSTANCE.expand());
            this.isExpanded = false;
        }
    }

    public String toUrlParams() {
        return "test=" + this.testCheckbox.getValue() + '&' + "filter" + '=' + (Object)((Object)this.getKeywordFilter());
    }
}

