/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.lcom4.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.gwt.ui.Icons;
import org.sonar.gwt.ui.Loading;
import org.sonar.gwt.ui.Page;
import org.sonar.plugins.design.ui.lcom4.client.Data;
import org.sonar.wsclient.gwt.AbstractCallback;
import org.sonar.wsclient.gwt.Callback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class Lcom4Tab
extends Page {
    public static final String GWT_ID = "org.sonar.plugins.design.ui.lcom4.Lcom4Tab";
    private VerticalPanel panel;

    protected Widget doOnResourceLoad(Resource resource) {
        this.panel = new VerticalPanel();
        this.panel.setWidth("100%");
        this.loadData(resource);
        return this.panel;
    }

    private void loadData(Resource resource) {
        this.panel.add((Widget)new Loading());
        ResourceQuery query = ResourceQuery.createForMetrics((String)resource.getId().toString(), (String[])new String[]{"lcom4", "lcom4_blocks"});
        Sonar.getInstance().find((Query)query, (Callback)new AbstractCallback<Resource>(){

            protected void doOnResponse(Resource resource) {
                Lcom4Tab.this.panel.clear();
                Lcom4Tab.this.panel.add((Widget)new Header(resource));
                if (resource != null && resource.getMeasure("lcom4_blocks") != null) {
                    String json = resource.getMeasure("lcom4_blocks").getData();
                    Data.Blocks blocks = Data.parse(json);
                    Grid grid = new Grid(blocks.size(), 2);
                    grid.setStyleName("lcom4blocks");
                    grid.getColumnFormatter().setStyleName(0, "index");
                    for (int indexBlock = 0; indexBlock < blocks.size(); ++indexBlock) {
                        Data.Block block = blocks.get(indexBlock);
                        grid.setHTML(indexBlock, 0, "<div class='index'>" + (indexBlock + 1) + "</div>");
                        VerticalPanel blockPanel = new VerticalPanel();
                        blockPanel.setStyleName("lcom4block");
                        for (int indexEntity = 0; indexEntity < block.size(); ++indexEntity) {
                            Data.Entity entity = block.get(indexEntity);
                            HTML row = new HTML(Icons.forQualifier((String)entity.getQualifier()).getHTML() + " " + entity.getName());
                            row.setStyleName("lcom4row");
                            blockPanel.add((Widget)row);
                        }
                        grid.setWidget(indexBlock, 1, (Widget)blockPanel);
                    }
                    Lcom4Tab.this.panel.add((Widget)grid);
                }
            }
        });
    }

    private static class Header
    extends Composite {
        private FlowPanel header = new FlowPanel();

        public Header(Resource resource) {
            this.header.setStyleName("gwt-ViewerHeader");
            HorizontalPanel panel = new HorizontalPanel();
            HTML html = new HTML("Lack of Cohesion of Methods: ");
            html.setStyleName("metric");
            panel.add((Widget)html);
            if (resource != null) {
                html = new HTML(resource.getMeasureFormattedValue("lcom4", "-"));
                html.setStyleName("value");
                panel.add((Widget)html);
            }
            this.header.add((Widget)panel);
            this.initWidget((Widget)this.header);
        }
    }
}

