/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.dependencies.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.gwt.Links;
import org.sonar.gwt.ui.Icons;
import org.sonar.plugins.design.ui.dependencies.client.Data;
import org.sonar.plugins.design.ui.dependencies.client.I18nConstants;
import org.sonar.wsclient.services.Dependency;

public class DependenciesTable
extends Composite {
    private HorizontalPanel panel = new HorizontalPanel();

    public DependenciesTable() {
        this.panel.setStylePrimaryName("dependencies");
        this.initWidget((Widget)this.panel);
    }

    public void display(Data data) {
        this.panel.clear();
        if (data.canDisplay()) {
            this.panel.add((Widget)this.createIncomingColumn(data));
            this.panel.add((Widget)this.createOutgoingColumn(data));
        } else {
            this.panel.add((Widget)new Label(I18nConstants.INSTANCE.noData()));
        }
    }

    private Panel createIncomingColumn(Data data) {
        FlexTable grid = new FlexTable();
        grid.setStyleName("col");
        grid.setWidget(0, 1, (Widget)new HTML("<b>" + I18nConstants.INSTANCE.afferentCouplings() + "</b>: " + data.getResource().getMeasureIntValue("ca")));
        grid.getRowFormatter().setStyleName(0, "coltitle");
        int row = 1;
        for (Dependency dependency : data.getDependencies()) {
            if (data.getResourceId() != dependency.getToId()) continue;
            this.addDependencyRow(grid, row, dependency.getFromId(), dependency.getFromName() + " (" + dependency.getWeight() + ")");
            grid.setWidget(row, 0, (Widget)Icons.forQualifier((String)dependency.getFromQualifier()).createImage());
            ++row;
        }
        return grid;
    }

    private Panel createOutgoingColumn(Data data) {
        FlexTable grid = new FlexTable();
        grid.setStyleName("col");
        grid.setWidget(0, 1, (Widget)new HTML("<b>" + I18nConstants.INSTANCE.efferentCouplings() + "</b>: " + data.getResource().getMeasureIntValue("ce")));
        grid.getRowFormatter().setStyleName(0, "coltitle");
        int row = 1;
        for (Dependency dependency : data.getDependencies()) {
            if (data.getResourceId() != dependency.getFromId()) continue;
            this.addDependencyRow(grid, row, dependency.getToId(), dependency.getToName() + " (" + dependency.getWeight() + ")");
            grid.setWidget(row, 0, (Widget)Icons.forQualifier((String)dependency.getToQualifier()).createImage());
            ++row;
        }
        return grid;
    }

    private void addDependencyRow(FlexTable grid, int row, final long resourceId, String name) {
        Label link = new Label(name);
        link.setStyleName("link");
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                Links.openResourcePopup((String)String.valueOf(resourceId));
            }
        });
        grid.setWidget(row, 1, (Widget)link);
    }
}

