/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.ui.dependencies.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.sonar.gwt.ui.Loading;
import org.sonar.gwt.ui.Page;
import org.sonar.plugins.design.ui.dependencies.client.Data;
import org.sonar.plugins.design.ui.dependencies.client.DependenciesTable;
import org.sonar.wsclient.gwt.AbstractCallback;
import org.sonar.wsclient.gwt.AbstractListCallback;
import org.sonar.wsclient.gwt.Callback;
import org.sonar.wsclient.gwt.ListCallback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Dependency;
import org.sonar.wsclient.services.DependencyQuery;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class DependenciesTab
extends Page {
    public static final String GWT_ID = "org.sonar.plugins.design.ui.dependencies.DependenciesTab";
    private FlowPanel panel = null;
    private DependenciesTable dependenciesTable = null;
    private Loading loading;

    protected Widget doOnResourceLoad(Resource resource) {
        this.prepare();
        Data data = new Data(resource.getId().intValue());
        this.loadMeasures(data);
        this.loadDependencies(data);
        return this.panel;
    }

    private void prepare() {
        if (this.panel == null) {
            this.panel = new FlowPanel();
            this.panel.getElement().setId("deps");
            this.loading = new Loading();
            this.dependenciesTable = new DependenciesTable();
            this.panel.setWidth("100%");
        }
        this.panel.clear();
        this.panel.add((Widget)this.loading);
    }

    private void loadMeasures(final Data data) {
        ResourceQuery query = new ResourceQuery(data.getResourceId());
        query.setMetrics(new String[]{"ce", "ca"});
        query.setVerbose(Boolean.valueOf(true));
        Sonar.getInstance().find((Query)query, (Callback)new AbstractCallback<Resource>(){

            protected void doOnResponse(Resource resource) {
                data.setMeasures(resource);
                DependenciesTab.this.displayMeasures(data);
            }
        });
    }

    private void loadDependencies(final Data data) {
        DependencyQuery query = DependencyQuery.createForResource((long)data.getResourceId());
        Sonar.getInstance().findAll((Query)query, (ListCallback)new AbstractListCallback<Dependency>(){

            protected void doOnResponse(List<Dependency> dependencies) {
                data.setDependencies(dependencies);
                DependenciesTab.this.displayMeasures(data);
            }
        });
    }

    private void displayMeasures(Data data) {
        if (data.isLoaded()) {
            this.panel.clear();
            this.dependenciesTable.display(data);
            this.panel.add((Widget)this.dependenciesTable);
        }
    }
}

