/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.batch;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TangleIndexDecorator
implements Decorator {
    private Metric tanglesMetric;
    private Metric edgesWeightMetric;
    private Metric tangleIndexMetric;

    protected TangleIndexDecorator(Metric tanglesMetric, Metric edgesWeightMetric, Metric tangleIndexMetric) {
        this.tanglesMetric = tanglesMetric;
        this.edgesWeightMetric = edgesWeightMetric;
        this.tangleIndexMetric = tangleIndexMetric;
    }

    @DependsUpon
    public final List<Metric> dependsUponMetrics() {
        return Arrays.asList(this.tanglesMetric, this.edgesWeightMetric);
    }

    @DependedUpon
    public final Metric generatesMetric() {
        return this.tangleIndexMetric;
    }

    public final boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public final void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(context)) {
            return;
        }
        Measure tangles = context.getMeasure(this.tanglesMetric);
        Measure totalweight = context.getMeasure(this.edgesWeightMetric);
        if (MeasureUtils.hasValue((Measure)totalweight)) {
            context.saveMeasure(new Measure(this.tangleIndexMetric, Double.valueOf(this.compute(MeasureUtils.getValue((Measure)tangles, (Double)0.0), totalweight.getValue()))));
        }
    }

    private boolean shouldDecorateResource(DecoratorContext context) {
        return context.getMeasure(this.tangleIndexMetric) == null;
    }

    private double compute(double tangles, double totalWeight) {
        if (totalWeight == 0.0) {
            return 0.0;
        }
        double result = 2.0 * tangles / totalWeight;
        return result * 100.0;
    }
}

