/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.batch;

import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.resources.Scopes;

public class SuspectLcom4DensityDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public final Metric generatesMetric() {
        return CoreMetrics.SUSPECT_LCOM4_DENSITY;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (!ResourceUtils.isFile((Resource)resource)) {
            if (Scopes.isDirectory((Resource)resource)) {
                this.decorateDirectory(context);
            } else if (Scopes.isProject((Resource)resource)) {
                this.decorateProject(context);
            }
        }
    }

    private void decorateProject(DecoratorContext context) {
        double total = 0.0;
        int totalFiles = 0;
        List children = context.getChildren();
        boolean hasLcom4 = false;
        for (DecoratorContext child : children) {
            int files = MeasureUtils.getValue((Measure)child.getMeasure(CoreMetrics.FILES), (Double)0.0).intValue();
            totalFiles += files;
            Measure childSuspectDensity = child.getMeasure(CoreMetrics.SUSPECT_LCOM4_DENSITY);
            if (childSuspectDensity == null || childSuspectDensity.getValue() == null) continue;
            hasLcom4 = true;
            total += childSuspectDensity.getValue() * (double)files;
        }
        if (hasLcom4 && totalFiles > 0) {
            context.saveMeasure(CoreMetrics.SUSPECT_LCOM4_DENSITY, Double.valueOf(total / (double)totalFiles));
        }
    }

    private void decorateDirectory(DecoratorContext context) {
        Collection fileLcoms = context.getChildrenMeasures(CoreMetrics.LCOM4);
        double files = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.FILES), (Double)0.0);
        if (!fileLcoms.isEmpty() && files > 0.0) {
            double suspectFiles = 0.0;
            for (Measure fileLcom : fileLcoms) {
                if (!(MeasureUtils.getValue((Measure)fileLcom, (Double)0.0) > 1.0)) continue;
                suspectFiles += 1.0;
            }
            double density = suspectFiles / files * 100.0;
            context.saveMeasure(CoreMetrics.SUSPECT_LCOM4_DENSITY, Double.valueOf(density));
        }
    }
}

