/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.graph.CycleDetector;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.graph.Dsm;
import org.sonar.graph.DsmTopologicalSorter;
import org.sonar.graph.MinimumFeedbackEdgeSetSolver;
import org.sonar.plugins.design.batch.DsmSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDsmDecorator
implements Decorator {
    private SonarIndex index;

    public ProjectDsmDecorator(SonarIndex index) {
        this.index = index;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Collection<Resource> subProjects;
        if (this.shouldDecorateResource(resource, context) && !(subProjects = this.getSubProjects((Project)resource)).isEmpty()) {
            Dsm<Resource> dsm = this.getDsm(subProjects);
            this.saveDsm(context, dsm);
        }
    }

    private void saveDsm(DecoratorContext context, Dsm<Resource> dsm) {
        Measure measure = new Measure(CoreMetrics.DEPENDENCY_MATRIX, DsmSerializer.serialize(dsm));
        measure.setPersistenceMode(PersistenceMode.DATABASE);
        context.saveMeasure(measure);
    }

    private Dsm<Resource> getDsm(Collection<Resource> subProjects) {
        CycleDetector cycleDetector = new CycleDetector((DirectedGraphAccessor)this.index, subProjects);
        Set cycles = cycleDetector.getCycles();
        MinimumFeedbackEdgeSetSolver solver = new MinimumFeedbackEdgeSetSolver(cycles);
        Set feedbackEdges = solver.getEdges();
        Dsm dsm = new Dsm((DirectedGraphAccessor)this.index, subProjects, feedbackEdges);
        DsmTopologicalSorter.sort((Dsm)dsm);
        return dsm;
    }

    private Collection<Resource> getSubProjects(Project project) {
        ArrayList subProjects = Lists.newArrayList();
        this.addSubProjects(project, subProjects);
        return subProjects;
    }

    private void addSubProjects(Project project, List<Resource> subProjects) {
        for (Project subProject : project.getModules()) {
            Project indexedSubProject = (Project)this.index.getResource((Resource)subProject);
            if (indexedSubProject != null) {
                subProjects.add((Resource)indexedSubProject);
            }
            this.addSubProjects(subProject, subProjects);
        }
    }

    private boolean shouldDecorateResource(Resource resource, DecoratorContext context) {
        return ResourceUtils.isProject((Resource)resource) && context.getMeasure(CoreMetrics.DEPENDENCY_MATRIX) == null;
    }
}

