/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.batch;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.StateDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.FilteringDependencyNodeVisitor;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.design.Dependency;
import org.sonar.api.resources.Library;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;

@SupportedEnvironment(value={"maven"})
public class MavenDependenciesSensor
implements Sensor {
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder treeBuilder;
    private SonarIndex index;

    public MavenDependenciesSensor(ArtifactRepository localRepository, ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, ArtifactCollector artifactCollector, DependencyTreeBuilder treeBuilder, SonarIndex index) {
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        this.artifactMetadataSource = artifactMetadataSource;
        this.artifactCollector = artifactCollector;
        this.index = index;
        this.treeBuilder = treeBuilder;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void analyse(Project project, final SensorContext context) {
        try {
            DependencyNode root = this.treeBuilder.buildDependencyTree(project.getPom(), this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector);
            BuildingDependencyNodeVisitor visitor = new BuildingDependencyNodeVisitor(new DependencyNodeVisitor(){

                public boolean visit(DependencyNode node) {
                    return true;
                }

                public boolean endVisit(DependencyNode node) {
                    if (node.getParent() != null && node.getParent() != node) {
                        MavenDependenciesSensor.this.saveDependency(node, context);
                    }
                    return true;
                }
            });
            StateDependencyNodeFilter filter = StateDependencyNodeFilter.INCLUDED;
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, (DependencyNodeFilter)filter);
            root.accept((DependencyNodeVisitor)firstPassVisitor);
            AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
            visitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
            root.accept((DependencyNodeVisitor)visitor);
        }
        catch (DependencyTreeBuilderException e) {
            throw new SonarException("Can not load the graph of dependencies of the project " + project.getKey(), (Throwable)e);
        }
    }

    protected void saveDependency(DependencyNode node, SensorContext context) {
        Project from = node.getParent().getParent() == null ? this.index.getProject() : MavenDependenciesSensor.toResource(node.getParent().getArtifact(), context);
        Resource to = MavenDependenciesSensor.toResource(node.getArtifact(), context);
        Dependency dependency = new Dependency((Resource)from, to);
        dependency.setUsage(node.getArtifact().getScope());
        dependency.setWeight(1);
        context.saveDependency(dependency);
    }

    protected static Resource toResource(Artifact artifact, SensorContext context) {
        Project project = Project.createFromMavenIds((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        Resource result = context.getResource((Resource)project);
        if (result == null || !((Project)result).getAnalysisVersion().equals(artifact.getBaseVersion())) {
            Library lib = new Library(project.getKey(), artifact.getBaseVersion());
            context.saveResource((Resource)lib);
            result = context.getResource((Resource)lib);
        }
        return result;
    }

    public String toString() {
        return "Maven dependencies";
    }
}

