/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.design.batch;

import org.sonar.api.design.Dependency;
import org.sonar.api.resources.Resource;
import org.sonar.graph.Dsm;
import org.sonar.graph.DsmCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DsmSerializer {
    private Dsm dsm;
    private StringBuilder json;

    private DsmSerializer(Dsm<Resource> dsm) {
        this.dsm = dsm;
        this.json = new StringBuilder();
    }

    private String serialize() {
        this.json.append('[');
        this.serializeRows();
        this.json.append(']');
        return this.json.toString();
    }

    private void serializeRows() {
        for (int y = 0; y < this.dsm.getDimension(); ++y) {
            if (y > 0) {
                this.json.append(',');
            }
            this.serializeRow(y);
        }
    }

    private void serializeRow(int y) {
        Resource resource = (Resource)this.dsm.getVertex(y);
        this.json.append("{");
        if (resource != null) {
            this.json.append("\"i\":");
            this.json.append(resource.getId());
            this.json.append(",\"n\":\"");
            this.json.append(resource.getName());
            this.json.append("\",\"q\":\"");
            this.json.append(resource.getQualifier());
            this.json.append("\",\"v\":[");
            for (int x = 0; x < this.dsm.getDimension(); ++x) {
                if (x > 0) {
                    this.json.append(',');
                }
                this.serializeCell(y, x);
            }
            this.json.append("]");
        }
        this.json.append("}");
    }

    private void serializeCell(int y, int x) {
        DsmCell cell = this.dsm.getCell(x, y);
        this.json.append('{');
        if (cell.getEdge() != null && cell.getWeight() > 0) {
            Dependency dep = (Dependency)cell.getEdge();
            this.json.append("\"i\":");
            this.json.append(dep.getId());
            this.json.append(",\"w\":");
            this.json.append(cell.getWeight());
        }
        this.json.append('}');
    }

    public static String serialize(Dsm<Resource> dsm) {
        return new DsmSerializer(dsm).serialize();
    }
}

