package ifi.dbtg.ldbe.web;

import ifi.dbtg.ldbe.charts.LDBEPanel;

import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.*;

import org.apache.log4j.Logger;

/**
 * main applet
 * @author Michal@Mourad
 *
 */
public class LDBEstart extends JApplet {
	private static final long serialVersionUID = -7441059811589602196L;
	public static final String PANEL1 = "Panel 1";
	public static final String PANEL2 = "Panel 2";
	public static final String PANEL3 = "Panel 3";
	private CardLayout cardlayout = new CardLayout();
	private JPanel mainPanel = new JPanel(cardlayout);

	public void init() {
		try {
			javax.swing.SwingUtilities.invokeAndWait(new Runnable() {
				public void run() {
					try {
						createGUI();
					} catch (SQLException e) {
						e.printStackTrace();
					} catch (IOException e) {
						e.printStackTrace();
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			});
		} catch (Exception e) {
			System.err.println("createGUI didn't successfully complete");
		}
	}

	private void createGUI() throws Exception {
//		Panel1 panel1 = new Panel1(this);
//		Panel2 panel2 = new Panel2();
		LDBEPanel panel3 = new LDBEPanel();

//		mainPanel.add(panel1, PANEL1);
		// mainPanel.add(panel2, PANEL2);
		mainPanel.add(panel3, PANEL3);
		getContentPane().add(mainPanel);
	}

	public void swapCard(String name) {
		cardlayout.show(mainPanel, name);
	}
}

class Panel1 extends JPanel {
	private static final long serialVersionUID = -1193847631541136614L;
	JTextField password;
	JButton submit;
	JLabel error;
	public Panel1(final LDBEstart newapplet) {
		error = new JLabel();
		error.setForeground(Color.RED);
		password = new JTextField(32);
		submit = new JButton("Submit");
		submit.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				if (password.getText().compareTo("1dbeW3b") == 0)
					newapplet.swapCard(LDBEstart.PANEL3);
				else
					error.setText("Wrong password");
			}
		});
		password.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				if (password.getText().compareTo("1dbeW3b") == 0)
					newapplet.swapCard(LDBEstart.PANEL3);
				else
					error.setText("Wrong password");
			}
		});
		add(new JLabel("Please Enter the Password:"));
		add(password);
		add(submit);
		add(error);
	}
}

class Panel2 extends JPanel {
	private static final long serialVersionUID = 9104270210518268981L;
	final static Logger logger = Logger.getLogger(Panel2.class);

	public Panel2() throws SQLException {
		add(new JLabel("Panel 2"));
	}

}
