package ifi.dbtg.ldbe.charts;

import ifi.dbtg.ldbe.algebra.IndexOutOfMatrixBoundariesException;
import ifi.dbtg.ldbe.algebra.NotMatchingSizeException;
import ifi.dbtg.ldbe.misc.InterpolationException;
import ifi.dbtg.ldbe.ts.TimeSeries;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.swing.JFrame;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeriesCollection;

/**
 * Handles displaying of original time series
 * @author Michal@Mourad
 *
 */
public class DisplayManager extends JFrame {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	final static Logger logger = Logger.getLogger(DisplayManager.class);

	private long lastTs = Long.MIN_VALUE;

	public XYSeriesCollection getXYSeriesCollection(TimeSeries[] tsarray)
			throws SQLException, NotMatchingSizeException,
			InterpolationException, IndexOutOfMatrixBoundariesException {
		XYSeriesCollection collection = new XYSeriesCollection();

		for (TimeSeries series : tsarray) {
			if (series.getLength() * series.getGranularity() > lastTs)
				lastTs = series.getLength() * series.getGranularity();
			collection.addSeries(series.getXYSeriesOriginal(0));
		}

		return collection;
	}

	public DisplayManager(TimeSeries[] ts) throws NotMatchingSizeException, SQLException, InterpolationException, IndexOutOfMatrixBoundariesException  {
		super();

		NumberAxis xAxis = new NumberAxis3D("Value");
		NumberAxis yAxis = new NumberAxis3D("Relative timestamp");

		TickUnitSource units = NumberAxis.createIntegerTickUnits();
		yAxis.setStandardTickUnits(units);

		XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);

		ScrollableXYPlot xyPlot = new ScrollableXYPlot(
				getXYSeriesCollection(ts), yAxis, xAxis, renderer, lastTs);

		JFreeChart chart = new JFreeChart("Original",
				JFreeChart.DEFAULT_TITLE_FONT, xyPlot, true);

		ChartPanel chartPanel = new ChartPanel(chart);

		try {
			ScrollableChartPane scrollableChartPane = new ScrollableChartPane(
					chartPanel, new ArrayList<ChartFrame>());
			scrollableChartPane.disableButtons();
			
			this.setContentPane(scrollableChartPane);
			setSize(ChartsManager.sideWindowsSizeWidth * 2,
					ChartsManager.sideWindowsSizeHeight * 2);
			setLocation(600, 0);
			setVisible(true);
			setResizable(false);
			addWindowListener(new CloseListener());

		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	private class CloseListener extends WindowAdapter {
		public void windowClosing(WindowEvent event) {
			dispose();
		}
	}

	@Override
	public void dispose() {
		super.dispose();
	}
}