package ifi.dbtg.ldbe.ts;

import ifi.dbtg.ldbe.db.DBConnection;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;

/**
 * Set of time series
 * 
 * @author Michal@Mourad
 * 
 */
public class TSSet {
	private final static long serialVersionUID = 1L;
	private final static Logger logger = Logger.getLogger(TSSet.class);

	// file: '2010.11.18 [05] SEST TS queries.sql' ; query: '06 - get set info'
	private static final String SQLQuerySetInfo = "SELECT (SELECT COUNT(1) FROM sets_series WHERE src_set=:id) len,granul gran, norm, label01 label, label02 descr FROM sets  WHERE id=:id ";

	// file: '2010.11.18 [05] SEST TS queries.sql' ; query: '07 - get series
	// ids'
	private static final String SQLQuerySetSeriesIds = "SELECT src_series series_id FROM sets_series WHERE src_set=:set_id";

	private static final String SQLQuerySetsIds = "SELECT id FROM sets ";

	private Integer id;
	private List<TimeSeries> tsList;
	private Integer length;
	private Integer granularity;
	private NormalizationMethod norm;
	private String label;

	public TSSet(int id) throws SQLException {
		this.setId(id);
		loadInfo();
	}

	public Object[] toObjectArray() {
		return new Object[] { this.getId(), this.label, this.granularity,
				this.norm, this.length };
	}

	public String[] toStringArray() {
		return new String[] { this.id.toString(), this.label,
				this.granularity.toString(), this.norm.toString(),
				this.length.toString() };
	}

	public List<TimeSeries> getTSList() throws SQLException {
		if (tsList == null)
			loadSeries();
		return tsList;
	}

	private void loadInfo() throws SQLException {
		OracleCallableStatement SQLStmt = (OracleCallableStatement) DBConnection
				.getConnection().prepareCall(SQLQuerySetInfo);

		SQLStmt.setIntAtName("id", getId());

		OracleResultSet rs = (OracleResultSet) SQLStmt.executeQuery();
		rs.next();

		this.length = rs.getInt("len");
		this.granularity = rs.getInt("gran");
		this.norm = NormalizationMethod.getNormalization(rs.getInt("norm"));
		this.label = rs.getString("label");

		if (rs.next())
			throw new RuntimeException("More rows than expected");

		SQLStmt.close();
		return;
	}

	private void loadSeries() throws SQLException {
		OracleCallableStatement SQLStmt = (OracleCallableStatement) DBConnection
				.getConnection().prepareCall(SQLQuerySetSeriesIds);

		if (tsList == null || length == 0) {
			tsList = new ArrayList<TimeSeries>(length);

			SQLStmt.setInt(1, getId());

			OracleResultSet rs = (OracleResultSet) SQLStmt.executeQuery();
			while (rs.next()) {
				int series_id = rs.getInt("series_id");
				tsList.add(new TimeSeries(series_id, this));
			}

			SQLStmt.close();
		}
		return;
	}

	public static List<TSSet> getSets() throws SQLException {
		List<TSSet> result = new ArrayList<TSSet>();
		OracleCallableStatement SQLStmt = (OracleCallableStatement) DBConnection
				.getConnection().prepareCall(SQLQuerySetsIds);

		OracleResultSet rs = (OracleResultSet) SQLStmt.executeQuery();
		while (rs.next()) {
			result.add(new TSSet(rs.getInt("id")));
		}

		SQLStmt.close();
		return result;
	}

	/**
	 * @param args
	 * @throws SQLException
	 */
	public static void main(String[] args) throws SQLException {
		for (TSSet set : TSSet.getSets()) {
			logger.info(set);
		}

	}

	public void setId(int id) {
		this.id = id;
	}

	public Integer getId() {
		return id;
	}

	public String getLabel() {
		return label;
	}

	public Integer getGranularity() {
		return granularity;
	}

	public NormalizationMethod getNormalization() {
		return norm;
	}

	public Integer getSize() {
		return length;
	}

}
