package ifi.dbtg.ldbe.ts;

/**
 * Enumerates implemented missing values recovery methods 
 * @author Michal@Mourad
 *
 */
public enum RecoveryMethod {
	DELETE_EVENTS, MIN_EVENTS, MEAN_EVENTS, NN1_EVENTS, LIN_INTERP_EVENTS, SVD, CENTROID;
	
	
	public static Integer getDeterminator(RecoveryMethod mthd) {
		return (int) Math.pow(2,mthd.ordinal());
	}

	public static String toString(RecoveryMethod mthd) {
		if (mthd == RecoveryMethod.DELETE_EVENTS)
			return "Deletion";
		if (mthd == RecoveryMethod.MIN_EVENTS)
			return "Minimum events";
		if (mthd == RecoveryMethod.MEAN_EVENTS)
			return "Average events";
		if (mthd == RecoveryMethod.NN1_EVENTS)
			return "Nearest Neighbour";
		if (mthd == RecoveryMethod.LIN_INTERP_EVENTS)
			return "Linear Interpolation";
		if (mthd == RecoveryMethod.SVD)
			return "SVD";
		if (mthd == RecoveryMethod.CENTROID)
			return "Centroid";
		return "";
	}
	
}
