package ifi.dbtg.ldbe.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;

/**
 * Singleton class for connection to DB
 * 
 * @author Michal@Mourad
 * 
 */
public class DBConnection {
	/**
	 * logger
	 */
	private final static Logger logger = Logger.getLogger(DBConnection.class);
	/**
	 * db connection
	 */
	private static Connection conn;

	private DBConnection() {
	}

	/**
	 * returns connection to DB
	 * 
	 * @return DB connection
	 * @throws SQLException
	 */
	public static Connection getConnection() throws SQLException {
		if (conn != null)
			return conn;

		logger.info("REBOM: Block Recovery in Time Series\n");
		logger.info("Checking DB connection:\n");
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());

		conn = DriverManager.getConnection(
		
		
				"jdbc:oracle:thin:@horatio.ifi.uzh.ch:1521:orcl", "username", "password");
		
	
		conn.setAutoCommit(false);
		Statement stmt = conn.createStatement();
		ResultSet rset = stmt.executeQuery("select BANNER from SYS.V_$VERSION");
		while (rset.next()) {
			logger.info(rset.getString(1));
		}
		stmt.close();
		logger.info("Ok.\n\n");
		return conn;
	}

	public static void main(String[] args) {
		try {
			DBConnection.getConnection();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
