package ifi.dbtg.ldbe.charts;

import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseWheelEvent;
import java.util.List;

import javax.swing.JScrollBar;

import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.jdbc.JDBCXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

/**
 * Component for browsing time series plot
 * @author Michal@Mourad
 *
 */
public class ScrollableXYPlot extends XYPlot implements ScrollablePlot {
	private static final long serialVersionUID = 1L;
	private static int EMPTY = -2;
	private static int DISTANCE_BEFORE_BLOCK = 2;

	private final static int valueSpan = 288;

	private JScrollBar scrollBar;
	private double domainUpperBound;
	private List<Integer> mvBlocksList = null;
	private int mvBlocksListIndex = EMPTY;

	public void setMVBlocksList(List<Integer> list) {
		this.mvBlocksList = list;
		if (list.size() > 0)
			this.mvBlocksListIndex = -1;
		else
			this.mvBlocksListIndex = EMPTY;
	}

	public void gotoNextMVBlock() {
		if (this.mvBlocksListIndex > EMPTY) {
			this.mvBlocksListIndex++;
			if (this.mvBlocksListIndex == this.mvBlocksList.size())
				this.mvBlocksListIndex = 0;
			this.scrollBar.setValue(this.mvBlocksList
					.get(this.mvBlocksListIndex)
					- ScrollableXYPlot.DISTANCE_BEFORE_BLOCK);
		}
	}

	public void gotoPrevMVBlock() {
		if (this.mvBlocksListIndex > EMPTY) {
			if (this.mvBlocksListIndex <= 0) {
				this.mvBlocksListIndex = this.mvBlocksList.size() - 1;
			} else {
				this.mvBlocksListIndex--;
			}

			this.scrollBar.setValue(this.mvBlocksList
					.get(this.mvBlocksListIndex)
					- ScrollableXYPlot.DISTANCE_BEFORE_BLOCK);
		}
	}


	public ScrollableXYPlot(XYDataset dataset, ValueAxis domainAxis,
			ValueAxis rangeAxis, XYLineAndShapeRenderer renderer,
			long lastTimestamp) {

		super(dataset, domainAxis, rangeAxis, renderer);
		// rangeAxis.setRange(-.025, 1.0);//TODO

		if (dataset instanceof JDBCXYDataset) {
			this.domainUpperBound = lastTimestamp;

		} else {
			this.domainUpperBound = ((XYSeriesCollection) dataset)
					.getDomainUpperBound(false);

		}

		
		this.getDomainAxis().setRange(0,valueSpan);
	}

	public void setScrollBar(JScrollBar scrollBar) {
		this.scrollBar = scrollBar;
		this.scrollBar.setMaximum((int) this.domainUpperBound + 2);
	}

	public void setRange(int value) {
		this.getDomainAxis().setRange(value,value+ScrollableXYPlot.valueSpan);
	}
	
	public void scrollBarValueChanged(AdjustmentEvent event) {
		this.setRange(event.getValue());
	}

	@Override
	public void mouseWheelScrolled(MouseWheelEvent event) {
	}

	public void dispose() {
		this.setDataset(null);
	}

}