package ifi.dbtg.ldbe.charts;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.sql.SQLException;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;

import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Plot;

/**
 * Component for browsing original time series plot and browsing missing values blocks
 * @author Michal@Mourad
 *
 */
public class ScrollableChartPane extends JPanel implements AdjustmentListener,
		ActionListener {
	private static final long serialVersionUID = 4126132915024047763L;
	private Box chartPaneBox = null;
	private Button butt1 = null;
	private Button butt2 = null;
	private ChartPanel chartPanel = null;
	private JScrollBar scrollBar = null;
	
	private List<ChartFrame> charts;
	

	public ScrollableChartPane(ChartPanel chartPanel,List<ChartFrame> charts) throws SQLException {
		super(new GridBagLayout());
		this.charts=charts;
		this.chartPanel = chartPanel;

		GridBagConstraints constraints = new GridBagConstraints();
		constraints = getConstraints(0, 0, 1, 2, GridBagConstraints.NONE, 0, 0,
				new Insets(0, 0, 0, 0), GridBagConstraints.CENTER, 0, 0);
		this.add(getChartBox(), constraints);

		this.setBorder(BorderFactory.createCompoundBorder(
				BorderFactory.createEmptyBorder(4, 4, 4, 4),
				BorderFactory.createEtchedBorder()));

		Plot plot = chartPanel.getChart().getPlot();
		if (plot instanceof ScrollablePlot) {
			((ScrollablePlot) plot).setScrollBar(this.getScrollBar());
		}

	}

	private GridBagConstraints getConstraints(int gridx, int gridy,
			int gridwidth, int gridheight, int fill, int ipadx, int ipady,
			Insets insets, int anchor, int weightx, int weighty) {
		GridBagConstraints constraints = new GridBagConstraints();
		constraints.gridx = gridx;
		constraints.gridy = gridy;
		constraints.gridwidth = 1;
		constraints.gridheight = 2;
		constraints.fill = GridBagConstraints.BOTH;
		constraints.ipadx = ipadx;
		constraints.ipady = ipady;
		constraints.insets = insets;
		constraints.anchor = anchor;
		constraints.weightx = weightx;
		constraints.weighty = weighty;
		return constraints;
	}

	private Box getChartBox() {
		if (chartPaneBox == null) {
			chartPaneBox = Box.createVerticalBox();
			chartPaneBox.add(getChartPanel());
			chartPaneBox.add(Box.createVerticalStrut(10));
			chartPaneBox.add(getScrollBar());

			// chartPaneBox.setAlignmentX(Component.LEFT_ALIGNMENT);
			// chartPaneBox.setAlignmentY(Component.TOP_ALIGNMENT);
			chartPaneBox.add(Box.createVerticalStrut(10));
			chartPaneBox.add(getMVButtons());

		}
		return chartPaneBox;
	}

	private Box getMVButtons() {
		Box buttonsBox = Box.createHorizontalBox();
		this.butt1 = new Button("Previous MV Block");
		this.butt1.addActionListener(this);
		buttonsBox.add(butt1);
		this.butt2 = new Button("Next MV Block");
		this.butt2.addActionListener(this);
		buttonsBox.add(butt2);

		return buttonsBox;
	}

	private ChartPanel getChartPanel() {
		chartPanel.setMaximumSize(new Dimension(710, 450));
		chartPanel.setMinimumSize(new Dimension(650, 450));
		return chartPanel;
	}

	public void disableButtons() {
		this.butt1.setEnabled(false);
		this.butt2.setEnabled(false);
	}

	public JScrollBar getScrollBar() {
		if (scrollBar == null) {
			scrollBar = new JScrollBar(SwingConstants.HORIZONTAL);
			scrollBar.setMinimum(0);
			scrollBar.addAdjustmentListener(this);

		}
		return scrollBar;
	}

	public void adjustmentValueChanged(AdjustmentEvent event) {
		Plot plot = null;
		if ((this.chartPanel != null) && (this.chartPanel.getChart() != null)
				&& (this.chartPanel.getChart().getPlot() != null)) {
			plot = this.chartPanel.getChart().getPlot();
			if (plot instanceof ScrollablePlot) {
				((ScrollablePlot) plot).scrollBarValueChanged(event);
				
				for (ChartFrame chart : charts) {
					((ScrollablePlot) chart.getChartPanel().getChart().getPlot()).scrollBarValueChanged(event);
				}
			}
		}
	}



	@Override
	public void actionPerformed(ActionEvent event) {
		Plot plot = null;
		if ((this.chartPanel != null) && (this.chartPanel.getChart() != null)
				&& (this.chartPanel.getChart().getPlot() != null)) {
			plot = this.chartPanel.getChart().getPlot();
			if (plot instanceof ScrollableXYPlot) {
				if (event.getSource() == this.butt1)
					((ScrollableXYPlot) plot).gotoPrevMVBlock();
				if (event.getSource() == this.butt2)
					((ScrollableXYPlot) plot).gotoNextMVBlock();
			}

		}

	}
}
