package ifi.dbtg.ldbe.charts;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

/**
 * main window component
 * @author Michal@Mourad
 *
 */
public class LDBEPanel extends JPanel {
	private static final long serialVersionUID = 1L;
	public TabGuide tabGuide;

	private CardLayout cardlayout = new CardLayout();
	private JPanel mainPanel = new JPanel(cardlayout);

	public LDBEPanel() throws Exception {


		JTabbedPane tp = new JTabbedPane();
		tp.addTab("Missing Values Recovery", null, new RecoveryTab(),
				"Recover missing values in time series.");
		tp.addTab("Display", null, new DisplayTab(),
				"displays original data for selecte time series");
		//tp.addTab("Help", null, new TabGuide(
		//		"https://files.ifi.uzh.ch/dbtg/khayati/rebom/guide/LDBE_Web_UGuide.pdf"),
		//		"displays user guide");

		tp.setSelectedIndex(0);

		setLayout(new GridLayout(1, 1));

			mainPanel.add(tp, "main");

		add(mainPanel);
	}

	public void swapCard(String name) {
		cardlayout.show(mainPanel, name);
	}

	public static void main(String[] args) throws Exception {
		JFrame f = new JFrame("REBOM");
		f.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

		f.getContentPane().add(new LDBEPanel(), BorderLayout.CENTER);
		f.setSize(1050, 480);
		f.setVisible(true);
	}

	class Panel1 extends JPanel {
		JPasswordField password;
		JTextField user;
		JButton submit;
		JLabel error;

		public Panel1(final LDBEPanel ldbePanel) {
			error = new JLabel();
			error.setForeground(Color.RED);
			password = new JPasswordField(20);
			user = new JTextField(20);
			submit = new JButton("Submit");
			submit.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					if (password.getText().compareTo("hydrologis") == 0
							&& user.getText().compareTo("hydrologis") == 0)
						ldbePanel.swapCard("main");
					else
						error.setText("Wrong password or user name");
				}
			});
			password.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					if (password.getText().compareTo("hydrologis") == 0
							&& user.getText().compareTo("hydrologis") == 0)
						ldbePanel.swapCard("main");
					else
						error.setText("Wrong password or user name");
				}
			});

			setLayout(new GridBagLayout());
			GridBagConstraints c = new GridBagConstraints();
			c.fill = GridBagConstraints.VERTICAL;
			// c.weightx = 0.15;

			c.gridx = 0;
			c.gridy = 0;
			c.insets = new Insets(1, 1, 1, 1);

			add(new JLabel("Please Enter the Username:"), c);
			c.gridx = 1;
			add(user, c);
			c.gridx = 0;
			c.gridy = 1;
			add(new JLabel("Please Enter the Password:"), c);
			c.gridx = 1;
			add(password, c);
			c.gridx = 1;
			c.gridy = 2;
			add(submit, c);
			c.gridx = 2;
			add(error, c);
		}
	}

}