package ifi.dbtg.ldbe.charts;

import ifi.dbtg.ldbe.algebra.IndexOutOfMatrixBoundariesException;
import ifi.dbtg.ldbe.algebra.NotMatchingSizeException;
import ifi.dbtg.ldbe.misc.InterpolationException;
import ifi.dbtg.ldbe.ts.TSSet;
import ifi.dbtg.ldbe.ts.TimeSeries;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.HashMap;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

import org.apache.log4j.Logger;

/**
 * Component for selecting original time series for display
 * @author Michal@Mourad
 *
 */
public class DisplayTab extends JPanel implements ActionListener, MouseListener {
	private static final long serialVersionUID = -2039806365965209124L;
	private static final Logger logger = Logger.getLogger(DisplayTab.class);

	JButton buttonDisplay;
	JFrame mainWindow;

	HashMap<Integer, TSSet> sets;
	HashMap<Integer, TimeSeries> series;

	DisplayManager display = null;
	JTable tableSets, tableRefSeries;
	JLabel info, labelError;

	JCheckBox cbMinValue, cbAvgValue, cbNN1Value, cbDel, cbSVD, cbInt,
			cbCentroid;

	public DisplayTab() throws SQLException {

		sets = new HashMap<Integer, TSSet>();
		for (TSSet set : TSSet.getSets()) {
			sets.put(set.getId(), set);
		}

		Object[][] data = new Object[sets.size()][];

		int i = 0;
		for (TSSet set : sets.values()) {
			data[i++] = set.toObjectArray();
		}

		this.tableSets = new JTable(new MyTableModel(
				RecoveryTab.columnNamesSets, data));
		tableSets.setAutoCreateRowSorter(true);
		tableSets.addMouseListener(this);
		tableSets.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tableSets.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

		tableSets.getColumnModel().getColumn(0).setPreferredWidth(50);
		tableSets.getColumnModel().getColumn(1).setPreferredWidth(180);
		tableSets.getColumnModel().getColumn(2).setPreferredWidth(90);
		tableSets.getColumnModel().getColumn(3).setPreferredWidth(90);
		tableSets.getColumnModel().getColumn(4).setPreferredWidth(85);

		tableRefSeries = new JTable(new MyTableModel(
				RecoveryTab.columnNamesSeries, new Object[0][0]));
		tableRefSeries.setAutoCreateRowSorter(true);
		tableRefSeries.addMouseListener(this);
		tableRefSeries.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tableRefSeries.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		tableRefSeries
				.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

		tableRefSeries.getColumnModel().getColumn(0).setPreferredWidth(50);
		tableRefSeries.getColumnModel().getColumn(1).setPreferredWidth(190);
		tableRefSeries.getColumnModel().getColumn(2).setPreferredWidth(100);
		tableRefSeries.getColumnModel().getColumn(3).setPreferredWidth(70);
		tableRefSeries.getColumnModel().getColumn(4).setPreferredWidth(85);

		JScrollPane spSets = new JScrollPane(tableSets);
		spSets.setPreferredSize(new Dimension(200, 230));
		spSets.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		spSets.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

		JScrollPane spReferenceSeries = new JScrollPane(tableRefSeries);
		spReferenceSeries.setPreferredSize(new Dimension(200, 230));
		spReferenceSeries
				.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		spReferenceSeries
				.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

		buttonDisplay = new JButton("Display");
		buttonDisplay.addActionListener(this);

		setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		// natural height, maximum width
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 0.75;

		c.gridwidth = 1;
		c.gridx = 0;
		c.gridy = 0;
		c.insets = new Insets(7, 2, 0, 0);
		JLabel l = new JLabel("Select a Set of Series:");
		l.setForeground(Color.BLUE);
		l.setBackground(Color.LIGHT_GRAY);
		add(l, c);

		// c.weightx = 0.25;
		c.gridwidth = 2;
		c.gridx = 1;
		c.gridy = 0;
		JLabel lRef = new JLabel("Select Time Series");
		lRef.setForeground(Color.BLUE);
		lRef.setBackground(Color.LIGHT_GRAY);
		add(lRef, c);

		c.gridwidth = 1;
		c.gridx = 0;
		c.gridy = 1;
		c.gridheight = 2;
		add(spSets, c);

		c.gridwidth = 2;
		// c.weightx = 0.5;
		c.gridx = 1;
		c.gridy = 1;
		c.gridheight = 2;
		add(spReferenceSeries, c);

		c.gridwidth = 1;
		c.gridx = 0;
		c.gridy = 3;

		cbMinValue = new JCheckBox("Minimum value");
		cbAvgValue = new JCheckBox("Average value");
		cbNN1Value = new JCheckBox("Nearest Neighbor");
		cbInt = new JCheckBox("Linear Interpolation");
		cbSVD = new JCheckBox("SVD");
		cbCentroid = new JCheckBox("Centroid");
		cbDel = new JCheckBox("Deletion");

		cbCentroid.setEnabled(true);

		JPanel checkBoxes = new JPanel();
		checkBoxes.setBorder(BorderFactory
				.createTitledBorder("Missing values imputation"));
		checkBoxes.setLayout(new GridBagLayout());
		GridBagConstraints cInner = new GridBagConstraints();
		cInner.anchor = GridBagConstraints.WEST;
		cInner.gridx = 0;
		cInner.gridy = 0;
		checkBoxes.add(cbMinValue, cInner);
		cInner.gridy = 1;
		checkBoxes.add(cbAvgValue, cInner);
		cInner.gridy = 2;
		checkBoxes.add(cbNN1Value, cInner);
		cInner.gridx = 1;
		cInner.gridy = 0;
		checkBoxes.add(cbInt, cInner);
		cInner.gridy = 1;
		checkBoxes.add(cbSVD, cInner);
		cInner.gridy = 2;
		checkBoxes.add(cbCentroid, cInner);
		cInner.gridx = 0;
		cInner.gridy = 3;
		checkBoxes.add(cbDel, cInner);

		add(checkBoxes, c);
		checkBoxes.setVisible(false);

		// buttons
		c.gridwidth = 1;
		c.gridx = 1;
		c.gridy = 3;

		JPanel buttonsPane = new JPanel();
		buttonsPane.setLayout(new GridBagLayout());
		GridBagConstraints cButtons = new GridBagConstraints();
		cButtons.gridwidth = 1;
		cButtons.fill = GridBagConstraints.HORIZONTAL;
		cButtons.gridx = 0;
		cButtons.gridy = 0;
		buttonsPane.add(buttonDisplay, cButtons);

		cButtons.gridx = 1;
		info = new JLabel();
		info.setForeground(Color.BLUE);
		buttonsPane.add(info, cButtons);

		cButtons.gridwidth = 3;
		cButtons.gridx = 1;
		cButtons.gridy = 1;
		labelError = new JLabel();
		labelError.setForeground(Color.RED);
		buttonsPane.add(labelError, cButtons);

		add(buttonsPane, c);
	}

	private TimeSeries[] getSeries() {
		TimeSeries[] result = new TimeSeries[tableRefSeries
				.getSelectedRowCount()];

		int aux = 0;
		for (int index : tableRefSeries.getSelectedRows()) {
			result[aux++] = series.get(tableRefSeries.getValueAt(index, 0));
		}

		return result;

	}

	public void actionPerformed(ActionEvent ev) {
		info.setText("   Data loading...");
		labelError.setText("");
		this.paintAll(getGraphics());
		if (ev.getSource() == buttonDisplay) {
			if (tableRefSeries.getSelectedRowCount() > 0) {
				TimeSeries[] ts = this.getSeries();
				logger.debug(ts);
				if (this.display != null) {
					this.display.dispose();
				}
				try {
					this.display = new DisplayManager(ts);
					info.setText("   Done.");
				} catch (SQLException e) {
					labelError.setText("   Connection problem");
					info.setText("");
					e.printStackTrace();
				} catch (NotMatchingSizeException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterpolationException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IndexOutOfMatrixBoundariesException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			} else {
				info.setText("");
				labelError.setText("Choose time series");
			}
		}
	}

	@Override
	public void mouseClicked(MouseEvent event) {
		if (event.getSource() == this.tableSets) {
			info.setText("");
			labelError.setText("");
			Integer setId = (Integer) tableSets.getValueAt(
					tableSets.getSelectedRow(), 0);
			logger.debug("set id: " + setId);
			try {
				series = new HashMap<Integer, TimeSeries>();

				for (TimeSeries ts : sets.get(setId).getTSList()) {
					series.put(ts.getId(), ts);
				}

				Object[][] data = new Object[series.size()][];

				int i = 0;
				for (TimeSeries ts : series.values()) {
					data[i++] = ts.toObjectArray();
				}

				MyTableModel modelRef = (MyTableModel) this.tableRefSeries
						.getModel();
				modelRef.setData(data);
				modelRef.fireTableDataChanged();

			} catch (SQLException e) {
				e.printStackTrace();
			}
		}

		// avoid selecting same series
		if (event.getSource() == this.tableRefSeries) {
			info.setText("");
			labelError.setText("");
			logger.debug("series id: "
					+ (Integer) tableRefSeries.getValueAt(
							tableRefSeries.getSelectedRow(), 0));
		}

	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
	}

	@Override
	public void mousePressed(MouseEvent arg0) {
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
	}
}