package ifi.dbtg.ldbe.algebra;

/**
 * represents vector datatype
 */
public final class Vector {
	static double dotProduct(double[] u, double[] v)
			throws NotMatchingSizeException {
		if (u.length != v.length) {
			throw new NotMatchingSizeException("size of vectors differs");
		}
		double prod = 0.0;
		for (int i = 0; i < u.length; i++)
			prod += u[i] * v[i];
		return prod;
	}

	public static double[] multiplyPairwise(double v[], double w[]) {
		double[] res = new double[v.length];

		for (int i = 0; i < v.length; i++)
			res[i] = v[i] * w[i];
		return res;
	}

	public static double[] subtractPairwise(double v[], double w[]) {
		double[] res = new double[v.length];

		for (int i = 0; i < v.length; i++)
			res[i] = v[i] - w[i];
		return res;
	}

	public static double[] multiply(double v[], double scalar) {
		double[] res = new double[v.length];
		for (int i = 0; i < v.length; i++)
			res[i] = v[i] * scalar;
		return res;
	}

	public static double[] divide(double v[], double scalar) {
		double[] res = new double[v.length];

		for (int i = 0; i < v.length; i++)
			res[i] = v[i] / scalar;
		return res;
	}

	public static double[] ones(int size) {
		double[] v = new double[size];

		for (int i = 0; i < v.length; i++)
			v[i] = 1;
		return v;
	}

	public static Matrix multiply(double[] u, double[] v) {
		Matrix aux = new Matrix(u.length, v.length);
		for (int r = 0; r < aux.rowNum(); r++) {
			for (int c = 0; c < aux.colNum(); c++) {
				aux.setEntry(r, c, u[r] * v[c]);
			}
		}
		return aux;
	}

	public static double multiplyByInversion(double[] u) {
		double res = 0;
		for (int i = 0; i < u.length; i++) {
			res += u[i] * u[i];
		}

		return res;
	}

}
